# Bereitet Beispiel aus http://de.wikipedia.org/wiki/SQL vor

DROP   DATABASE IF EXISTS wikipedia_sql_example;
CREATE DATABASE           wikipedia_sql_example;
USE                       wikipedia_sql_example;

CREATE TABLE Student (
	MatrNr	INT(10)  UNSIGNED 
			         UNIQUE
			         NOT NULL
			         AUTO_INCREMENT,
	Name	CHAR(64) NOT NULL,

	PRIMARY KEY (MatrNr)
);

CREATE TABLE Professor (
	PersNr	INT(10)  UNSIGNED 
			         UNIQUE
			         NOT NULL
			         AUTO_INCREMENT,
	Name	CHAR(64) NOT NULL,

	PRIMARY KEY (PersNr)
);

CREATE TABLE Vorlesung (
	VorlNr	INT(10)  UNSIGNED 
			         UNIQUE
			         NOT NULL
			         AUTO_INCREMENT,
	Titel	CHAR(64) NOT NULL,
	PersNr	INT(10)  UNSIGNED
			         NULL,

	PRIMARY KEY (VorlNr),
	FOREIGN KEY (PersNr) REFERENCES Professor(PersNr)
		ON DELETE SET NULL 
		ON UPDATE CASCADE
);

CREATE TABLE hört (
	MatrNr	INT(10) UNSIGNED,
	VorlNr	INT(10) UNSIGNED,

	PRIMARY KEY (MatrNr, VorlNr),
	FOREIGN KEY (MatrNr) REFERENCES Student(MatrNr)
		ON DELETE CASCADE 
		ON UPDATE CASCADE,
	FOREIGN KEY (VorlNr) REFERENCES Vorlesung(VorlNr)
		ON DELETE CASCADE 
		ON UPDATE CASCADE
);


